<?php
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/data/user/userpic/Userpic.class.php');

/**
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class UserPicturePage extends AbstractPage {
	public $templateName = 'userPicture';
	
	public $picture;

	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		
		$data = WCF::getDB()->getFirstRow("SELECT * FROM wcf".WCF_N."_user_pictures WHERE userID = ".intval($_REQUEST['userID']));
		if($data['userpicID'] == 0) {
			require_once(WCF_DIR.'lib/system/exception/IllegalLinkException.class.php');
			throw new IllegalLinkException();
		}
		
		$this->picture = new Userpic(null, $data);
		
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		
		
		WCF::getTPL()->assign(
			array('picture' => $this->picture)
		);
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {

		if(!MODULE_USERPIC)
		{
			throw new IllegalLinkException();
		}
				
		parent::show();
	}

}
?>